<?php 
header("Access-Control-Allow-Origin: *");
include '../../../conexion/conexion.php';
include '../../../librarys/generic_request.php';


$datos = array();
$type = addslashes($_REQUEST["type"]);

switch ($type) {
	case 'with_exist':
		$buscar = "SELECT prd.*, lbs.name AS laboratorio FROM products prd INNER JOIN laboratories lbs ON lbs.id_laboratory=prd.id_laboratory";	
		$ex_b = mysqli_query($conexion,$buscar);
		if(mysqli_num_rows($ex_b)>0){
			while($rows = mysqli_fetch_array($ex_b)){
				$_st = 0;
				$query = "SELECT stock FROM inventory WHERE id_product=".$rows["id_product"];
				$ex = mysqli_query($conexion,$query);
				while($stock = mysqli_fetch_array($ex)){
					$_st += floatval($stock["stock"]);
				}
				$rows["stock"]=$_st;
				$datos["info"][]=$rows;
			}
			$datos["val"]=true;	
		}else{
			$datos["val"]=false;
			$datos["info"]="";
			$datos["mensaje"]="No se encontraron productos.";
		}

		break;

	case 'price_historic_by_id':
		$id_product = addslashes($_REQUEST["id_product"]);
		$buscar = "SELECT im.*, prv.name AS provider FROM inventory_movements im INNER JOIN providers prv ON prv.id_provider=im.id_provider WHERE im.id_product=".$id_product." ORDER BY im.id_inventory_movement DESC LIMIT 7 " ;
		$ex_b = mysqli_query($conexion,$buscar);
		if(mysqli_num_rows($ex_b)>0){
			while($rows = mysqli_fetch_array($ex_b)){
				$rows["average"] = ((floatval($rows["cost"])*100)/floatval($rows["price"]));
				$datos["info"][]=$rows;
			}
			$datos["val"]=true;	
		}else{
			$datos["val"]=false;
			$datos["info"]="";
			$datos["mensaje"]="No se encontraron valores.";
		}
		break;

	case 'full_data_between_dates':
		$fecha_ini = addslashes($_REQUEST["fecha_ini"]);
		$fecha_fin = addslashes($_REQUEST["fecha_fin"]);
		$admissions = array();
		$gastos = array();
		$payments = array();
		$expenses = array();
		$financial_data = array();

		$providers = [];
		$exp_by_provider = [];

		$incomes_pay_methods = [];
		$data_incomes_pay_methods = [];
		$super_total_incomes = 0;

		$data_pay_offs_pay_methods = [];
		$pay_offs_pay_methods = [];
		$super_total_pay_offs = 0;
		$type_expenses["products"]["interno"] = [];
		$type_expenses["products"]["interno"]["total"] = 0;
		
		$type_expenses["products"]["externo"] = [];
		$type_expenses["products"]["externo"]["total"] = 0;

		$type_expenses["services"]["interno"] = [];
		$type_expenses["services"]["interno"]["total"] = 0;
		
		$type_expenses["services"]["externo"] = [];
		$type_expenses["services"]["externo"]["total"] = 0;

		$unique_warehouses["products"]["interno"] = [];
		$unique_warehouses["products"]["externo"] = [];

		$unique_warehouses["services"]["interno"] = [];
		$unique_warehouses["services"]["externo"] = [];


		$dates = getDatesFromRange($fecha_ini,$fecha_fin);
		foreach ($dates as $key => $date) {

			//BUSCAR ADMISSIONS
				$query = "SELECT pat.name AS pat_name, pat.father_surname AS pat_fsur, pat.mother_surname AS pat_msur, pat.gender, ads.*,(SELECT hr.name FROM hospital_rooms hr WHERE hr.id_hospital_room=ads.id_hospital_room) hospital_room FROM admissions ads INNER JOIN patients pat ON pat.id_patient=ads.id_patient WHERE ads.date_time>='".$date." 00:00:01' AND ads.date_time<='".$date." 23:59:59' ORDER BY ads.date_time ASC";	
				$ex = mysqli_query($conexion,$query);
				if(mysqli_num_rows($ex)>0){		
					$info = [];
					while($ads = mysqli_fetch_array($ex)){
						$ads["admon"]=find_admon($ads["id_admon"],$conexion);
						$info["date"]=$date;
						$info["admissions"][] = $ads;
					}			
					$admissions[] = $info;
				}

			//BUSCAR GASTOS POR CONCEPTO DE INGRESO HOSPITALARIO
				$query = "SELECT * FROM tickets tks WHERE tks.status=1 AND tks.date_time>='".$date." 00:00:01' AND tks.date_time<='".$date." 23:59:59' ORDER BY tks.date_time ASC";
				$ex = mysqli_query($conexion,$query);
				if(mysqli_num_rows($ex)){
					$info = [];
					
					$total = 0;
					while($ticket = mysqli_fetch_array($ex)){
						$ticket["admon"]=find_admon($ticket["id_admon"],$conexion);

						$info["date"]=$date;
						
						if($ticket["status"]=='1'){
							$ticket["products"]=[];
							$ticket["services"]=[];

							$ticket["patient"] = find_patient($ticket["id_patient"],$conexion);
							$total += floatval($ticket["total"]);							
							$qr_productos = "SELECT scp.*, wh.type FROM shopping_car_products scp INNER JOIN warehouses wh ON wh.id_warehouse=scp.id_warehouse WHERE scp.id_ticket=".$ticket["id_ticket"]." AND scp.status=1";

							$expr = mysqli_query($conexion,$qr_productos);
							while($prds = mysqli_fetch_array($expr)){
								$prds["warehouse"]=find_warehouse($prds["id_warehouse"],$conexion);
								$prds["admon"]=find_admon($prds["id_admon"],$conexion);

								//DEFINIR POR TIPO DE GASTO INTERNO=1 EXTERNO=2
								switch ($prds["type"]) {
									case '1':
										// GASTO INTERNO
										if(!in_array($unique_warehouses["products"]["interno"],$prds["warehouse"]["id_warehouse"])){
											$unique_warehouses["products"]["interno"][]=$prds["warehouse"]["id_warehouse"];					
											$type_expenses["products"]["interno"]["warehouses"][$prds["warehouse"]["name"]][]=$prds;
										}else{
											$key = array_search($unique_warehouses["products"]["interno"],$prds["warehouse"]["id_warehouse"]);
											$type_expenses["products"]["interno"]["warehouses"][$key][]=$prds;
										}
										$type_expenses["products"]["interno"]["total"] += floatval($prds["total"]);
										break;
									
									case '2':
										// GASTO EXTERNO										
										if(!in_array($unique_warehouses["products"]["externo"],$prds["warehouse"]["id_warehouse"])){
											$unique_warehouses["products"]["externo"][]=$prds["warehouse"]["id_warehouse"];					
											$type_expenses["products"]["externo"]["warehouses"][$prds["warehouse"]["name"]][]=$prds;
										}else{
											$key = array_search($unique_warehouses["products"]["externo"],$prds["warehouse"]["id_warehouse"]);
											$type_expenses["products"]["externo"]["warehouses"][$key][]=$prds;
										}

										$type_expenses["products"]["externo"]["total"] += floatval($prds["total"]);
										break;
								}

								$ticket["products"][]=$prds;

							}

							$qr_servicios = "SELECT scs.*, ts.id_type_service, ts.name AS type_service, ts.type FROM shopping_car_services scs INNER JOIN services sc ON sc.id_service=scs.id_service RIGHT JOIN type_services ts ON ts.id_type_service=sc.id_type_service WHERE scs.id_ticket=".$ticket["id_ticket"]." AND scs.status=1";
							$exsr = mysqli_query($conexion,$qr_servicios);
							while($srvs = mysqli_fetch_array($exsr)){
								$srvs["admon"]=find_admon($srvs["id_admon"],$conexion);
								switch ($srvs["type"]) {
									case '1':
										// GASTO INTERNO

										if(!in_array($unique_warehouses["services"]["interno"],$srvs["id_type_service"])){
											$unique_warehouses["services"]["interno"][]=$srvs["id_type_service"];					
											$type_expenses["services"]["interno"]["type_services"][$srvs["type_service"]][]=$srvs;
										}else{
											$key = array_search($unique_warehouses["services"]["interno"],$srvs["type"]);
											$type_expenses["services"]["interno"]["type_services"][$srvs["type_service"]][]=$srvs;
										}

										$type_expenses["services"]["interno"]["total"] += floatval($srvs["total"]);
										break;
									
									case '2':
										// GASTO EXTERNO
										if(!in_array($unique_warehouses["services"]["externo"],$srvs["id_type_service"])){
											$unique_warehouses["services"]["externo"][]=$srvs["id_type_service"];					
											$type_expenses["services"]["externo"]["type_services"][$srvs["type_service"]][]=$srvs;
										}else{
											$key = array_search($unique_warehouses["services"]["externo"],$srvs["type"]);
											$type_expenses["services"]["externo"]["type_services"][$srvs["type_service"]][]=$srvs;
										}
										$type_expenses["services"]["externo"]["total"] += floatval($srvs["total"]);
										break;
								}

								$ticket["services"][]=$srvs;
							}
						}
						$info["tickets"][]=$ticket;
					}
					$info["total"]=$total;
					$gastos[] = $info;
				}

			//BUSCAR INGRESOS ECONOMICOS HOSPITALARIOS	
				$query = "SELECT * FROM payments pays WHERE pays.date_time>='".$date." 00:00:01' AND pays.date_time<='".$date." 23:59:59' ORDER BY pays.date_time ASC";
				$ex = mysqli_query($conexion,$query);
				if(mysqli_num_rows($ex)){
					$info = [];
					$total = 0;
					while($pays = mysqli_fetch_array($ex)){
						$pays["admon"]=find_admon($pays["id_admon"],$conexion);
						$pays["pay_method"]=find_pay_method($pays["id_pay_method"],$conexion);

						$info["date"]=$date;

						if($pays["status"]=='1'){
							$total += floatval($pays["total"]);
							$super_total_incomes += floatval($pays["total"]);
							if(!in_array($pays["id_pay_method"],$incomes_pay_methods)){
								$incomes_pay_methods[]=$pays["id_pay_method"];								
								$tempo["id_pay_method"]=$pays["id_pay_method"];
								$tempo["pay_method"]=$pays["pay_method"]["name"];
								$tempo["total"]=floatval($pays["total"]);
								$data_incomes_pay_methods[]=$tempo;
							}else{
								$key = array_search($pays["id_pay_method"],$incomes_pay_methods);
								$data_incomes_pay_methods[$key]["total"] = floatval($data_incomes_pay_methods[$key]["total"])+floatval($pays["total"]);
							}
						}
						
						$info["payments"][]=$pays;
					}
					$info["total"]=$total;
					$payments["hospitalarios"][] = $info;
				}

			//BUSCAR INGRESOS ECONOMICOS OTROS (RENTA DE CONSULTORIOS MEDICOS)
				$query = "SELECT *,(SELECT cr.name FROM consulting_rooms cr WHERE cr.id_consulting_room=apps.id_consulting_room) AS consulting_room FROM appointments apps WHERE apps.date_time>='".$date." 00:00:01' AND apps.date_time<='".$date." 23:59:59' ORDER BY apps.date_time ASC";
				$ex = mysqli_query($conexion,$query);
				if(mysqli_num_rows($ex)){
					$info = [];
					$total = 0;
					while($apps = mysqli_fetch_array($ex)){
						$apps["admon"]=find_admon($apps["id_admon"],$conexion);
						$apps["doctor"]=find_doctor($apps["id_doctor"],$conexion);
						$apps["pay_method"]=find_pay_method($apps["id_pay_method"],$conexion);
						$apps["consulting_room"]=find_consulting_room($apps["id_consulting_room"],$conexion);
						$info["date"]=$date;
						
						if($apps["payed"]=='1'&&$apps["status"]!="0"){
							$total += floatval($apps["total"]);
							$super_total_incomes += floatval($apps["total"]);
							if(!in_array($apps["id_pay_method"],$incomes_pay_methods)){
								$incomes_pay_methods[]=$apps["id_pay_method"];								
								$tempo["id_pay_method"]=$apps["id_pay_method"];
								$tempo["pay_method"]=$apps["pay_method"]["name"];
								$tempo["total"]=floatval($apps["total"]);
								$data_incomes_pay_methods[]=$tempo;
							}else{
								$key = array_search($apps["id_pay_method"],$incomes_pay_methods);
								$data_incomes_pay_methods[$key]["total"] = floatval($data_incomes_pay_methods[$key]["total"])+floatval($apps["total"]);
							}
						}
						
						$info["appointments"][]=$apps;
					}
					$info["total"]=$total;
					$payments["consultorios"][] = $info;
				}

			//BUSCAR EGRESOS DE CLINICA
				$query = "SELECT * FROM expenses exp WHERE exp.date_time>='".$date." 00:00:01' AND exp.date_time<='".$date." 23:59:59' ORDER BY exp.date_time ASC";
				$ex = mysqli_query($conexion,$query);
				if(mysqli_num_rows($ex)){
					$info = [];
					$pagado = 0;
					$pendiente = 0;
				
					while($exps = mysqli_fetch_array($ex)){
						$exps["admon"]=find_admon($exps["id_admon"],$conexion);
						$exps["provider"]=find_provider($exps["id_provider"],$conexion);
						$exps["pay_method"]=find_pay_method($exps["id_pay_method"],$conexion);
						$info["date"]=$date;
						
						if($exps["status_exp"]=='1'&&$exps["status"]=="1"){
							$pagado += floatval($exps["amount"]);
							$super_total_pay_offs += floatval($exps["amount"]);

							if(!in_array($exps["id_pay_method"],$pay_offs_pay_methods)){
								$pay_offs_pay_methods[]=$exps["id_pay_method"];								
								$tempo["id_pay_method"]=$exps["id_pay_method"];
								$tempo["pay_method"]=$exps["pay_method"]["name"];
								$tempo["total"]=floatval($exps["amount"]);
								$data_pay_offs_pay_methods[]=$tempo;
							}else{
								$key = array_search($exps["id_pay_method"],$pay_offs_pay_methods);
								$data_pay_offs_pay_methods[$key]["total"] = floatval($data_pay_offs_pay_methods[$key]["total"])+floatval($exps["amount"]);
							}
						}

						if($exps["status_exp"]=='0'&&$exps["status"]=="1"){
							$pendiente += floatval($exps["amount"]);
						}
						
						if(!in_array($exps["id_provider"], $providers)){

							$providers[]=$exps["id_provider"];
							$prd_data["payed"] = ($exps["status_exp"]=='1'&&$exps["status"]=="1")?floatval($exps["amount"]):0;
							$prd_data["pending"] = ($exps["status_exp"]=='0'&&$exps["status"]=="1")?floatval($exps["amount"]):0;
							$prd_data["total"] = ($exps["status"]=="1")?floatval($exps["amount"]):0;

							$prd_data["provider"] = $exps["provider"]["name"];
							$prd_data["id_provider"] = $exps["id_provider"];

							$exp_by_provider[] = $prd_data;

						}else{						
							$key = array_search($exps["id_provider"],$providers);			
							if($exps["status_exp"]=='1'&&$exps["status"]=="1")
								$exp_by_provider[$key]["payed"] = floatval($exp_by_provider[$key]["payed"])+floatval($exps["amount"]);

							if($exps["status_exp"]=='0'&&$exps["status"]=="1")		
								$exp_by_provider[$key]["pending"] = floatval($exp_by_provider[$key]["pending"])+floatval($exps["amount"]);

							if($exps["status"]=="1")
								$exp_by_provider[$key]["total"] =  floatval($exp_by_provider[$key]["total"])+floatval($exps["amount"]);
						}
						
						$info["expenses"][]=$exps;
					}
					$info["payed"]=$pagado;
					$info["pending"]=$pendiente;
					$expenses[] = $info;
				}
		}


		$datos["val"]=true;	
		$datos["info"]["admissions"]=$admissions;

		$datos["info"]["patient_expenses"]=$gastos;

		$datos["info"]["payments"]=$payments;

		$datos["info"]["clinic_expenses"]["by_day"]=$expenses;
		$datos["info"]["clinic_expenses"]["by_provider"]=$exp_by_provider;

		$datos["info"]["financial_data"]["incomes"]["by_pay_method"]=$data_incomes_pay_methods;
		$datos["info"]["financial_data"]["incomes"]["super_total"]=$super_total_incomes;

		$datos["info"]["financial_data"]["pay_offs"]["by_pay_method"]=$data_pay_offs_pay_methods;
		$datos["info"]["financial_data"]["pay_offs"]["super_total"]=$super_total_pay_offs;
		
		$datos["info"]["financial_data"]["expenses_by_type"]=$type_expenses;
		$datos["mensaje"]="Algo bien! :)";

		break;

	case 'admissions-by-date':
		$initial_date  = addslashes($_REQUEST["initial_date"]);
		$final_date = addslashes($_REQUEST["final_date"]);
		$results_by_hour = array();
		$results_by_dw = array();

		// Creamos un arreglo de horas que te interesa filtrar
		$valid_hours = [0, 1, 2, 3, 4, 6, 7, 8, 9, 10, 11, 12, 13, 14, 16, 17, 19, 20, 21, 22, 23];

		// Convertimos el arreglo a una lista separada por comas para la consulta SQL
		$hours_list = implode(",", $valid_hours);

		// Preparamos la consulta con el filtro de fechas y horas
		$sql = "SELECT *, HOUR(date_time) AS hour, DAYOFWEEK(date_time) AS day_of_week
		        FROM tickets 
		        WHERE date_time BETWEEN ? AND ? 
		        AND HOUR(date_time) IN ($hours_list) AND status<>0";

		// Utilizamos una sentencia preparada para mayor seguridad
		if ($stmt = $conexion->prepare($sql)) {
		    // Ligamos los parámetros a la consulta
		    $stmt->bind_param("ss", $initial_date, $final_date);
		    
		    // Ejecutamos la consulta
		    $stmt->execute();
		    
		    // Obtenemos los resultados
		    $result = $stmt->get_result();
		    $sum_by_hour = array();
		    $sum_by_day = array();
		    // Si hay resultados, los recorremos
		    if ($result->num_rows > 0) {
		        while ($row = $result->fetch_assoc()) {
		        	$hour = $row['hour'];
		        	$day_of_week = $row['day_of_week'];

					if (!isset($results_by_hour[$hour])) {
		                $results_by_hour[$hour] = [];
		                $sum_by_hour[$hour] = [];
		            }
		            
		            if (!isset($results_by_dw[$day_of_week])) {
		                $results_by_dw[$day_of_week] = [];
		                $sum_by_day[$day_of_week] = [];
		            }

		            // Agregamos el registro al array de la hora correspondiente
		            $results_by_hour[$hour][] = $row;
		            $results_by_dw[$day_of_week][] = $row;

		            $sum_by_hour[$hour][] = $row["total"];
					$sum_by_day[$day_of_week][] = $row["total"];
		        }

		        $total_sum_by_day = array();
		        $total_sum_by_hour = array();

		        foreach ($sum_by_hour as $key => $value) {
		        	if(!isset($total_sum_by_hour[$key])){
		        		$total_sum_by_hour[$key] = [];
		        	}
		        	$total_sum_by_hour[$key]=round(array_sum($value),2);
		        }

		         foreach ($sum_by_day as $key => $value) {
		         	if(!isset($total_sum_by_day[$key])){
		        		$total_sum_by_day[$key] = [];
		        	}

		        	$total_sum_by_day[$key]=round(array_sum($value),2);
		        }



		        $datos["val"]=true;	
		        $datos["info"]=array(
		        	"hour"=>$results_by_hour,
		        	"day_of_week"=>$results_by_dw,
		        	"sum_by_hour"=>$total_sum_by_hour,
					"sum_by_day"=>$total_sum_by_day
		        );

				$datos["mensaje"]="";

		    } else {
		        $datos["val"]=false;
				$datos["info"]="";
				$datos["mensaje"]="No se encontraron productos.";
		    }	

		    // Cerramos la sentencia
		    $stmt->close();
		}else{
			$datos["val"]=false;
			$datos["info"]="";
			$datos["mensaje"]="No se encontraron productos.";
		}

		break;

	case 'reporte_ernesto':
		$data = array();
		$full = array();

		$initial_date  = addslashes($_REQUEST["initial_date"]);
		$final_date  = addslashes($_REQUEST["final_date"]);
		$invoiced = "";
		if(isset($_REQUEST['invoiced'])){
			$invoiced = 'AND adm.invoiced<>0';
		}

		$total_amount = 0;
		$query = "
		SELECT adm.*,
			CONCAT(ads.nombre,' ',ads.apellidos) AS admon_name,
			CONCAT(pts.name,' ',pts.father_surname,' ',pts.mother_surname) AS patient_name, pts.gender AS pts_gender, pts.birthday AS pts_birthday,
			CONCAT(drs.name,' ',drs.surnames) AS doctor_name, drs.medical_specialties, drs.cedula,
			hr.name AS hr_name,
			ata.id_admissions_type_admissions,
			ta.id_type_admission, ta.type AS type_admission,
			afta.id_admissions_file_type_admission,
			cco.id_clinical_commitment_order,cco.date_death, cco.folio_def,cco.diagnosis AS initial_diagnosis,
			coc.id_commitment_orders_clinic, coc.id_doctor AS coc_id_doctor, coc.id_anestesiologo, coc.diagnosis,
	        pic.id_informed_consent, ic.name AS informed_consent,
	        scs.id_shopping_car_services, scs.id_service, scs.quantity AS scs_quantity, scs.price AS scs_price, scs.total AS scs_total, scs.name AS scs_name, scs.description AS scs_description,
	        bc.id_birth_control, bc.type AS bc_type, bc.gender AS bc_gender, bc.weight AS bc_weight, bc.state AS bc_state, bc.folio AS bc_folio, bc.talla AS bc_talla
			FROM admissions adm 
				LEFT JOIN admons ads 
					ON ads.id_admon = adm.id_admon
				LEFT JOIN patients pts 
					ON pts.id_patient = adm.id_patient
				LEFT JOIN doctors drs 
					ON drs.id_doctor = adm.id_doctor
				LEFT JOIN hospital_rooms hr 
					ON hr.id_hospital_room = adm.id_hospital_room
				LEFT JOIN admissions_type_admissions ata 
					ON ata.id_admission = adm.id_admission 
					LEFT JOIN type_admissions ta 
						ON ta.id_type_admission = ata.id_type_admission
					LEFT JOIN admissions_file_type_admission afta 
						ON afta.id_admissions_type_admissions  = ata.id_admissions_type_admissions
				LEFT JOIN clinical_commitment_orders cco 
					ON cco.id_admissions_file_type_admission = afta.id_admissions_file_type_admission 
				LEFT JOIN commitment_orders_clinic coc 
					ON coc.id_admissions_file_type_admission = afta.id_admissions_file_type_admission
				LEFT JOIN patients_informed_consents pic 
					ON pic.id_admissions_file_type_admission = afta.id_admissions_file_type_admission
				LEFT JOIN informed_consents ic 
					ON ic.id_informed_consent = pic.id_informed_consent
				LEFT JOIN shopping_car_services scs 
					ON scs.id_admission = adm.id_admission AND scs.id_ticket<>0 AND  scs.status=1
				LEFT JOIN birth_control bc 
					ON bc.id_admission = adm.id_admission AND bc.status=1
			WHERE adm.date_ingreso BETWEEN '".$initial_date."' AND '".$final_date."' AND adm.status=2 $invoiced 
		ORDER BY adm.id_admission ASC" ;
		
		$ex = mysqli_query($conexion,$query);
		if(mysqli_num_rows($ex)>0){			
			while($rows = mysqli_fetch_assoc($ex)){
				$id = $rows["id_admission"];
				if(!isset($data[$id])){
					$fecha1 = new DateTime($rows["date_ingreso"]);
					$fecha2 = new DateTime($rows["last_update"]);
					$lp = get_last_payment($rows["id_admission"],$conexion);
					$last_payment = new DateTime($lp);

					$time_admission = ($fecha1->diff($last_payment))->days;
					$total_amount += floatval($rows["total"]);
					$data[$id] = array(
						"admission"=>array(
							"id_admission"=>$rows["id_admission"],
							"date_ingreso"=>$rows["date_ingreso"],
							"time_ingreso"=>$rows["time_ingreso"],
							"invoiced"=>floatval($rows["invoiced"]),
							"time_admission"=>$time_admission,
							"hospital_room"=>array(
								"id_hospital_room"=>$rows["id_hospital_room"],
								"name"=>$rows["hr_name"]
							),
							"total"=>floatval($rows["total"]),
							"date_time"=>$rows["date_time"],
							"last_update"=>$lp,
						),
						"patient"=>array(
							"id_patient"=>$rows["id_patient"],
							"name"=>$rows["patient_name"],
							"gender"=>$rows["pts_gender"],
							"age"=>intval(date("Y"))-intval($rows["pts_birthday"])
						),
						"admon"=>array(
							"name"=>$rows["admon_name"]
						),
						"doctor"=>array(
							"id_doctor"=>$rows["id_doctor"],
							"name"=>$rows["doctor_name"],
							"medical_specialties"=>$rows["medical_specialties"],
							"cedula"=>$rows["cedula"],
						),
						"type_admissions"=>[],
						"services"=>[],
						"birth_control"=>[],
						"clinical_commitment_orders"=>null
					);

					if(!isset($full["time_admission"][$time_admission])){
						$full["time_admission"][$time_admission] = 1;
					}else{
						$cont = $full["time_admission"][$time_admission]+1;
						$full["time_admission"][$time_admission] = $cont;				
					}

					if(!isset($full["doctors"][$rows["doctor_name"]])){
						$full["doctors"][$rows["doctor_name"]] = 1;
					}else{
						$cont = $full["doctors"][$rows["doctor_name"]]+1;
						$full["doctors"][$rows["doctor_name"]] = $cont;				
					}

					if(!isset($full["gender"][$rows["pts_gender"]])){
						$full["gender"][$rows["pts_gender"]] = 1;
					}else{
						$cont = $full["gender"][$rows["pts_gender"]]+1;
						$full["gender"][$rows["pts_gender"]] = $cont;				
					}


				}

				$id_ata = $rows["id_admissions_type_admissions"];
				if(!isset($data[$id]["type_admissions"][$id_ata])){
					$data[$id]["type_admissions"][$id_ata] = array(
						"id_admissions_type_admissions"=>$id_ata,
						"name"=>$rows["type_admission"],
						"commitment_orders"=>[],
						"informed_consents"=>[],
					);
				}

				if($rows["id_clinical_commitment_order"]!=null){
					$data[$id]["clinical_commitment_orders"] = [
						"id_clinical_commitment_order"=>$rows["id_clinical_commitment_order"],
						"date_death"=>$rows["date_death"],
						"folio_def"=>$rows["folio_def"],
						"initial_diagnosis"=>$rows["initial_diagnosis"]
					];
				}

				if($rows["id_commitment_orders_clinic"]!=null){
					$data[$id]["type_admissions"][$id_ata]["commitment_orders"][] = [
						"id_admissions_file_type_admission"=>$rows["id_admissions_file_type_admission"],
						"id_commitment_orders_clinic"=>$rows["id_commitment_orders_clinic"],
						"doctor"=>$rows["coc_id_doctor"],
						"diagnosis"=>$rows["diagnosis"]
					];

					if(!isset($full["diagnosis"][$rows["diagnosis"]])){
						$full["diagnosis"][$rows["diagnosis"]] = 1;
					}else{
						$cont = $full["diagnosis"][$rows["diagnosis"]]+1;
						$full["diagnosis"][$rows["diagnosis"]] = $cont;				
					}
				}

				if($rows["id_informed_consent"]!=null){
					$data[$id]["type_admissions"][$id_ata]["informed_consents"][] = [
						"id_informed_consent"=>$rows["id_informed_consent"],
						"informed_consent"=>$rows["informed_consent"]
					];

					if(!isset($full["informed_consent"][$rows["informed_consent"]])){
						$full["informed_consent"][$rows["informed_consent"]] = 1;
					}else{
						$cont = $full["informed_consent"][$rows["informed_consent"]]+1;
						$full["informed_consent"][$rows["informed_consent"]] = $cont;				
					}
				}

				if($rows["id_service"]!=null){
					$id_shopping_car_services =$rows["id_shopping_car_services"];
					$id_service = $rows["id_service"];

					if(!isset($full["services"][$id_service])){
						$full["services"][$id_service] = [
							"id_service"=>$rows["id_service"],
							"name"=>$rows["scs_name"],
							"description"=>$rows["scs_description"]
						];
					}

					if(!isset($data[$id]["services"][$id_shopping_car_services])){
						$data[$id]["services"][$id_shopping_car_services] = array(
							"id_shopping_car_services"=>$id_shopping_car_services,
							"id_service"=>$rows["id_service"],
							"quantity"=>$rows["scs_quantity"],
							"price"=>$rows["scs_price"],
							"total"=>$rows["scs_total"],
							"name"=>$rows["scs_name"],
							"description"=>$rows["scs_description"]
						);
					}
				}

				if($rows["id_birth_control"]!=null){
					if(!isset($data[$id]["birth_control"][$rows["id_birth_control"]])){
						$data[$id]["birth_control"][$rows["id_birth_control"]] = array(
							"id_birth_control"=>$rows["id_birth_control"],
							"type"=>$rows["bc_type"],
							"gender"=>$rows["bc_gender"],
							"weight"=>$rows["bc_weight"],
							"state"=>$rows["bc_state"],
							"talla"=>$rows["bc_talla"],
							"folio"=>$rows["bc_folio"]
						);
					}
				}

			}

			$first = array_values($data);
			foreach ($first as $a => $b) {
				$first[$a]["type_admissions"] = array_values($b["type_admissions"]);
				$first[$a]["services"] = array_values($b["services"]);
				$first[$a]["birth_control"] = array_values($b["birth_control"]);
			}

			$doctors =  array();
			foreach (array_keys($full["doctors"]) as $a => $b) {
				$name = array_keys($full["doctors"])[$a];
				$doctors[] = array(
					"name"=>$name,
					"value"=>$full["doctors"][$name]
				);
			}

			$diagnosis =  array();
			foreach (array_keys($full["diagnosis"]) as $a => $b) {
				$name = array_keys($full["diagnosis"])[$a];
				$diagnosis[] = array(
					"name"=>$name,
					"value"=>$full["diagnosis"][$name]
				);
			}

			$informed_consent =  array();
			foreach (array_keys($full["informed_consent"]) as $a => $b) {
				$name = array_keys($full["informed_consent"])[$a];
				$informed_consent[] = array(
					"name"=>$name,
					"value"=>$full["informed_consent"][$name]
				);
			}

			$time_admissions =  array();
			foreach (array_keys($full["time_admission"]) as $a => $b) {
				$name = array_keys($full["time_admission"])[$a];
				$time_admissions[] = array(
					"name"=>$name." dia(s)",
					"value"=>$full["time_admission"][$name]
				);
			}

			$genders =  array();
			foreach (array_keys($full["gender"]) as $a => $b) {
				$name = array_keys($full["gender"])[$a];
				$genders[] = array(
					"name"=>$name,
					"value"=>$full["gender"][$name]
				);
			}

			$services = array_values($full["services"]);
			/*foreach ( $full["services"] as $key => $value) {
				$data = array_values($full["services"])[$key];
				$services[] = array(
					"name"=>$name,
					"value"=>$full["services"][$data]["cont"],
					"id_service"=>$full["services"][$data]["id_service"]
				);
			}*/

			$datos["val"]=true;
			$datos["info"]=array("admissions"=>$first,"doctors"=>($doctors),"diagnosis"=>$diagnosis,"informed_consent"=>$informed_consent,"time_admission"=>$time_admissions,"total_amount"=>$total_amount,"genero"=>$genders,"services"=>$services);
			$datos["mensaje"]="";
		}else{
			$datos["val"]=false;
			$datos["info"]="";
			$datos["mensaje"]="No se encontraron registros.";
		}

		
		break;

	case 'reporte_farmacia':
		$data = array();
		$products = array();
		

		$initial_date  = addslashes($_REQUEST["initial_date"]);
		$final_date  = addslashes($_REQUEST["final_date"]);

		$total_amount = 0;
		$query = "
		SELECT adm.*,
		CONCAT(ads.nombre,' ',ads.apellidos) AS admon_name,
		CONCAT(pts.name,' ',pts.father_surname,' ',pts.mother_surname) AS patient_name, pts.gender AS pts_gender, pts.birthday AS pts_birthday,
		hr.name AS hr_name,
        scp.id_shopping_car_product, scp.id_product, scp.quantity AS scp_quantity, ROUND(scp.price + scp.taxes,2) AS unit_price, scp.total AS scp_total, scp.name AS scp_name, scp.description AS scp_description, scp.status AS scp_status, scp.id_ticket
		FROM admissions adm 
		LEFT JOIN admons ads ON ads.id_admon = adm.id_admon
		LEFT JOIN patients pts ON pts.id_patient = adm.id_patient
		LEFT JOIN hospital_rooms hr ON hr.id_hospital_room = adm.id_hospital_room
		LEFT JOIN shopping_car_products scp ON scp.id_admission = adm.id_admission AND scp.id_ticket<>0 AND scp.id_warehouse=5 AND scp.status=1 AND scp.total>0
		WHERE adm.date_time BETWEEN '".$initial_date."' AND '".$final_date."' AND adm.status=2
		ORDER BY adm.id_admission ASC" ;
		$ex = mysqli_query($conexion,$query);
		if(mysqli_num_rows($ex)>0){			
			while($rows = mysqli_fetch_assoc($ex)){
				$id = $rows["id_admission"];
				if(!isset($data[$id])){
			
					$data[$id] = array(
						"admission"=>array(
							"id_admission"=>$rows["id_admission"],
							"date_ingreso"=>$rows["date_ingreso"],
							"time_ingreso"=>$rows["time_ingreso"],
							"invoiced"=>floatval($rows["invoiced"]),
							"hospital_room"=>array(
								"id_hospital_room"=>$rows["id_hospital_room"],
								"name"=>$rows["hr_name"]
							),
							"date_time"=>$rows["date_time"],
						),
						"patient"=>array(
							"id_patient"=>$rows["id_patient"],
							"name"=>$rows["patient_name"],
							"gender"=>$rows["pts_gender"],
							"age"=>intval(date("Y"))-intval($rows["pts_birthday"])
						),
						"admon"=>array(
							"name"=>$rows["admon_name"]
						),
						"farmacia_principal"=>[],
						"total_fm"=>0
					);

					
				}

				
				$id_product = $rows["id_product"];
				if($id_product!=null){

					$unit_price = floatval($rows["unit_price"]);//YA INCLUYE IMPUESTOS
					$quantity = floatval($rows["scp_quantity"]);
					$total = floatval($rows["scp_total"]);

					$data[$id]["total_fm"]  = $data[$id]["total_fm"] +  $total;

					if(!isset($data[$id]["farmacia_principal"][$id_product])){
						$data[$id]["farmacia_principal"][$id_product] = array(
							"id_product"=>$rows["id_product"],
							"tickets"=>$rows["id_ticket"],
							"unit_price"=>$unit_price,
							"quantity"=>$quantity,
							"total"=>$total,
							"name"=>$rows["scp_name"],
							"description"=>$rows["scp_description"]
						);


					}else{
						//SI SI ESTÁ INICIALIZADO, SUMAR EL TOTAL PRESENTE Y ACUMULAR LA CANTIDAD  DE PRODUCTO
						$data[$id]["farmacia_principal"][$id_product]["quantity"] = $data[$id]["farmacia_principal"][$id_product]["quantity"] + $quantity;
						$data[$id]["farmacia_principal"][$id_product]["total"] = $data[$id]["farmacia_principal"][$id_product]["total"]+$total;
						$data[$id]["farmacia_principal"][$id_product]["tickets"] = $data[$id]["farmacia_principal"][$id_product]["tickets"].", ".$rows["id_ticket"];
					}

					//GUARDAR LAS VENTAS POR PRODUCTO

					if(!isset($products[$id_product])){
						$products[$id_product] = array(
							"id_product"=>$rows["id_product"],
							"tickets"=>$rows["id_ticket"],
							"unit_price"=>$unit_price,
							"quantity"=>$quantity,
							"total"=>$total,
							"name"=>$rows["scp_name"],
							"description"=>$rows["scp_description"]
						);
					}else{
						$products[$id_product]["quantity"] = $products[$id_product]["quantity"] + $quantity;
						$products[$id_product]["total"] = $products[$id_product]["total"] + $total;
						$products[$id_product]["tickets"] = $products[$id_product]["tickets"] .", ".$rows["id_ticket"];
					}
				}
			}

			$first = array_values($data);
			foreach ($first as $key => $value) {
				$first[$key]["farmacia_principal"] = array_values($first[$key]["farmacia_principal"]);
			}

			$datos["val"] = true;
			$datos["info"] = array(
				"admissions"=>$first,
				"products"=>array_values($products)
			);
			$datos["mensaje"] = "" ;

		}else{
			$datos["val"]=false;
			$datos["info"]="";
			$datos["mensaje"]="No se encontraron registros.";
		}

		
		break;
}

function get_last_payment($id_admission,$conexion){
	$select = "SELECT date_time FROM payments WHERE id_admission= $id_admission AND status=1 ORDER BY id_payment DESC LIMIT 1";
	$x = mysqli_query($conexion,$select);
	if(mysqli_num_rows($x)>0){
		$data = mysqli_fetch_assoc($x);
		return $data["date_time"];
	}else{
		return '0000-00-00 00:00:00';
	}

}



echo json_encode($datos);
mysqli_close($conexion);
?>

