<?php 
 
include '../../../conexion/conexion.php';
$datos = array();
/*$d = array(
    "datos_paciente" => array(
        "nombre" => "Mauricio Perez Vazquez",
        "fecha_nacimiento" => "1991-07-31",
        "genero" => "M",
        "aseguradora" => "Qualitas",
        "poliza" => "51564AB"
    ),
    "datos_ingreso" => array(
        "fecha_ingreso" => "2025-10-11 11:50:00",
        "llega_en_amb" => 0,
        "llega_en_pie" => 0,
        "llega_en_particular" => 1,
        "fecha_hora_incidente" => "2025-10-11 09:15:00"
    ),
    "antecedentes" => array(
        "ahf" => "Madre con diabetes tipo 2, Padre con hipertensión arterial",
        "app" => "Hipertiroidismo",
        "apnp" => "Consumo social de alcohol los fines de semana, Es empleado de construcción, con exposición frecuente a polvo y ruido.",
        "alergias" => "",
        "medicamentos_cronicos" => "Levotiroxina 1/4 pastilla",
        "adicciones" => "",
        "otros_antecedentes" => ""
    ),
    "antecedentes_catalogados" => array( // Array (lista)
        array("id_mv_antecedente_cronico" => 15),
        array("id_mv_antecedente_cronico" => 18),
        array("id_mv_antecedente_cronico" => 20)
    ),
    "mecanismo_lesion" => array(
        "acc_auto" => "Alcance,Choque frontal,Asiento posterior",
        "acc_motocicleta" => "",
        "acc_bicicleta" => "",
        "acc_peaton" => "",
        "acc_escolar" => ""
    ),
    "exploracion_fisica" => array(
        "temperatura" => 39.0,
        "talla" => "Mediana",
        "peso" => 65.0,
        "ta" => "110/60",
        "fc" => 85,
        "fr" => 75,
        "pulso" => 60,
        "rots" => "rots",
        "glasgow" => "13/15",
        "edo_gral" => "Conciente",
        "mec_lesion_momento" => "Choque frontal con cinturón de seguridad y bolsa de aire",
        "mec_lesion_posterior" => "Dolor cervical y rigidez de cuello",
        "descripcion_lesiones" => "Quemadura de 1er grado en brazo derecho"
    ),
    "estudios_imagen" => array(
        "rx_craneo" => 1,
        "rx_cervical" => 0,
        "rx_dorsal" => 0,
        "rx_lumbar" => 0,
        "rx_torax" => 0,
        "rx_oseo" => 0,
        "rx_abdomen" => 0,
        "rx_hombro" => 0,
        "rx_brazo" => 0,
        "rx_antebrazo" => 0,
        "rx_mano" => 0,
        "rx_muslo" => 0,
        "rx_pierna" => 0,
        "rx_tobillo_pie" => 0,
        "rx_pelvis" => 0,
        "rx_rodilla" => 0,
        "rx_otro" => "",
        "ultrasonido" => 1,
        "rmn" => 1,
        "tac" => 0,
        "otros_imagen" => "",
        "descripcion_imagen" => ""
    ),
    "diagnostico" => array(
        "diagnostico_principal" => "Traumatismo cervical por latigazo",
        "diagnostico_no_rel" => "Hipertiroidismo descompensado"
    ),
    "prescripcion_medicamentos" => array( // Array (lista)
        array(
            "id_medicamento" => 1,
            "cantidad" => "1",
            "indicacion" => "Cada 12 rs por 3 días"
        ),
        array(
            "id_medicamento" => 2,
            "cantidad" => "1",
            "indicacion" => "Cada 24 hrs por 5 días"
        ),
        array(
            "id_medicamento" => 3,
            "cantidad" => "1",
            "indicacion" => "Cada 8 hrs por 2 días"
        )
    ),
    "interconsulta_procedimientos" => array(
        "solicita_interconsulta" => 1,
        "especialidad" => "Cirugía Ortopédica",
        "suturas" => 4,
        "curaciones" => 0,
        "pronostico" => "Favorable",
        "observaciones" => "Se realizan 4 suturas por corte expuesto en pierna derecha",
        "inmovilizacion" => 1,
        "co_blando" => 0,
        "co_semirrigido" => 0,
        "co_philadelphia" => 0,
        "cabestrillo" => 0,
        "faja" => 0,
        "ferula" => 0,
        "otro_inmovilizacion" => "ostenedor quirúrgico",
        "uso_por" => "7 días",
        "retiro_fecha" => "2025-10-18"
    ),
    "hospitalizacion" => array(
        "motivo_hosp" => "Perdida de extremidad",
        "traslado_hosp" => "Hospital Central de Trauma",
        "fecha_hora" => "2025-10-11 13:30:00",
        "autoriza" => "Dr. Smith",
        "datos_ambulancia" => "Ambulancia Alfa 1"
    )
);*/
$type =$_REQUEST['type'];
$id_admon = addslashes($_REQUEST["id_admon"]);
switch ($type) {
    case 'nota_medica':
        $d = $_REQUEST['data'];
        $p   = $d['datos_paciente'];
        $i   = $d['datos_ingreso'];
        $a   = $d['antecedentes'];
        $ml  = $d['mecanismo_lesion'];
        $ef  = $d['exploracion_fisica'];
        $img = $d['estudios_imagen'];
        $dx  = $d['diagnostico'];
        $proc  = $d['interconsulta_procedimientos'];
        $hosp  = $d['hospitalizacion'];


        $cols = "id_admon, nombre, fecha_nacimiento, genero, fecha_ingreso, aseguradora, poliza, llega_en_amb, llega_en_pie, llega_en_particular, fecha_hora_incidente, 
            ahf, app, apnp, alergias, medicamentos_cronicos, adicciones, otros_antecedentes, 
            acc_auto, acc_motocicleta, acc_bicicleta, acc_peaton, acc_escolar, acc_otro, 
            temperatura, talla, peso, ta, fc, fr, pulso, rots, glasgow, edo_gral,
            mec_lesion_momento, mec_lesion_posterior, 
            descripcion_lesiones, 
            rx_craneo, rx_cervical, rx_dorsal, rx_lumbar, rx_torax, rx_oseo, rx_abdomen, rx_hombro, rx_brazo, rx_antebrazo, rx_mano, rx_muslo, rx_pierna, rx_tobillo_pie, rx_pelvis, rx_rodilla, rx_otro,
            ultrasonido, rmn, tac, otros_imagen, 
            descripcion_imagen, diagnostico_principal, diagnostico_no_rel, 
            solicita_interconsulta, especialidad, curaciones, suturas, inmovilizacion, co_blando, co_semirrigido, co_philadelphia, cabestrillo, faja, ferula, otro_inmovilizacion, uso_por, retiro_fecha, 
            pronostico, observaciones, 
            motivo_hosp, traslado_hosp, fecha_hora_hosp, autoriza, datos_ambulancia";
        $array_cols = array_values(array_filter(array_map('trim', explode(',', $cols))));
        $placeholders = rtrim(str_repeat('?,', sizeof($array_cols)), ',');

        try {
            $conexion->begin_transaction();
            $sql = "INSERT INTO mv_notas_medicas ($cols) VALUES ($placeholders)";
            $stmt = $conexion->prepare($sql);
            $stmt->bind_param(
                "issssssiiissssssssssssssdsdsiiissssssiiiiiiiiiiiiiiiisiiissssisiiiiiiiiissssssssss",
                $id_admon, $p['nombre'], $p['fecha_nacimiento'], $p['genero'], $i['fecha_ingreso'], $p['aseguradora'], $p['poliza'], $i['llega_en_amb'], $i['llega_en_pie'], $i['llega_en_particular'], $i['fecha_hora_incidente'],
                
                $a['ahf'], $a['app'], $a['apnp'], $a['alergias'], $a['medicamentos_cronicos'], $a['adicciones'], $a['otros_antecedentes'],
               
                $ml['acc_auto'], $ml['acc_motocicleta'], $ml['acc_bicicleta'], $ml['acc_peaton'], $ml['acc_escolar'],$ml['acc_otro'],
                
                $ef['temperatura'], $ef['talla'], $ef['peso'], $ef['ta'], $ef['fc'], $ef['fr'], $ef['pulso'], $ef['rots'], $ef['glasgow'], $ef['edo_gral'], 
               
                $ef['mec_lesion_momento'], $ef['mec_lesion_posterior'], 
                
                $ef['descripcion_lesiones'],
                
                $img['rx_craneo'], $img['rx_cervical'], $img['rx_dorsal'], $img['rx_lumbar'], $img['rx_torax'], $img['rx_oseo'], $img['rx_abdomen'],
                $img['rx_hombro'], $img['rx_brazo'], $img['rx_antebrazo'], $img['rx_mano'], $img['rx_muslo'], $img['rx_pierna'], $img['rx_tobillo_pie'], $img['rx_pelvis'], $img['rx_rodilla'], $img['rx_otro'], 
                
                $img['ultrasonido'], $img['rmn'], $img['tac'], $img['otros_imagen'], 
                
                $img['descripcion_imagen'], $dx['diagnostico_principal'], $dx['diagnostico_no_rel'],
                
                $proc['solicita_interconsulta'], $proc['especialidad'], $proc['curaciones'], $proc['suturas'], $proc['inmovilizacion'], $proc['co_blando'], $proc['co_semirrigido'], $proc['co_philadelphia'], $proc['cabestrillo'], $proc['faja'], $proc['ferula'], $proc['otro_inmovilizacion'], $proc['uso_por'], $proc['retiro_fecha'],
                
                $proc['pronostico'], $proc['observaciones'],
                
                $hosp['motivo_hosp'], $hosp['traslado_hosp'], $hosp['fecha_hora'], $hosp['autoriza'], $hosp['datos_ambulancia']
            );

            $stmt->execute();
            $id_nota = $conexion->insert_id;
            $stmt->close();

            // prescripciones
            if (!empty($d['prescripcion_medicamentos'])) {
                $sp = $conexion->prepare("INSERT INTO mv_notas_prescripciones(id_mv_nota_medica,id_medicamento,cantidad,indicacion,status) VALUES(?,?,?,?,1)");
                foreach ($d['prescripcion_medicamentos'] as $px) {
                    $id_med = $px['id_medicamento'];
                    $cant   = (string)$px['cantidad'];
                    $indi   = (string)$px['indicacion'];
                    $sp->bind_param('iiss', $id_nota, $id_med, $cant, $indi);
                    $sp->execute();
                }
                $sp->close();
            }

            // antecedentes catalogados
            if (!empty($d['antecedentes_catalogados'])) {
                $sa = $conexion->prepare("INSERT INTO mv_notas_antecedentes_cat(id_mv_nota_medica,id_mv_antecedente_cronico,status) VALUES(?,?,1)");
                foreach ($d['antecedentes_catalogados'] as $ax) {
                    $id_ant = $ax['id_mv_antecedente_cronico'];
                    $sa->bind_param('ii', $id_nota, $id_ant);
                    $sa->execute();
                }
                $sa->close();
            }

            $conexion->commit();
            $datos["val"]=true;
            $datos["info"]=$id_nota;
            $datos["mensaje"]="Nota medica $id_nota, creada exitosamente.";


        } catch (Throwable $e) {
            if ($conexion->errno === 0) {
                // ya en modo excepciones, pero aseguro rollback
            }
            $conexion->rollback();
            echo json_encode(['ok' => 0, 'error' => $e->getMessage()], JSON_UNESCAPED_UNICODE);
            $datos["val"]=false;
            $datos["info"]=0;
            $datos["mensaje"]=$e->getMessage();
        }

        break;
    
    case 'antecedentes_cronicos':
        $nombre = $_REQUEST['name'];

        $buscar = "SELECT * FROM mv_antecedentes_cronicos WHERE nombre_antecedente = ?";
        $buscar = $conexion->prepare($buscar);
        $buscar->bind_param("s",$nombre);
        $buscar->execute();

        $res = $buscar->get_result();
        if($res->num_rows==0){
            $save = "INSERT INTO  mv_antecedentes_cronicos (nombre_antecedente)VALUES(?)";
            $save = $conexion->prepare($save);
            $save->bind_param("s",$nombre);
            if($save->execute()){
                $datos["val"]=true;
                $datos["info"]="";
                $datos["mensaje"]="Antecedente registrado exitosamente";
            }else{
                 $datos["val"]=false;
                $datos["info"]="";
                $datos["mensaje"]="Ocurrio un error al registrar el antecedente ".$nombre." registrado exitosamente";
            }
            $save->close();
        }else{
            $datos["val"]=false;
            $datos["info"]="";
            $datos["mensaje"]="El antecedente que intentas registrar ya esta registrado";
        }
        $buscar->close();
        break;

    case 'medicamento':
        $nombre = $_REQUEST['name'];
        $presentacion = $_REQUEST['presentacion'];

        $buscar = "SELECT * FROM mv_cat_medicamentos WHERE nombre_generico = ? AND presentacion = ?";
        $buscar = $conexion->prepare($buscar);
        $buscar->bind_param("ss",$nombre, $presentacion);
        $buscar->execute();

        $res = $buscar->get_result();
        if($res->num_rows==0){
            $save = "INSERT INTO mv_cat_medicamentos (nombre_generico,presentacion)VALUES(?,?)";
            $save = $conexion->prepare($save);
            $save->bind_param("ss",$nombre, $presentacion);
            if($save->execute()){
                $datos["val"]=true;
                $datos["info"]="";
                $datos["mensaje"]="Medicamento registrado exitosamente";
            }else{
                 $datos["val"]=false;
                $datos["info"]="";
                $datos["mensaje"]="Ocurrio un error al registrar el medicamento ".$nombre." registrado exitosamente";
            }
            $save->close();
        }else{
            $datos["val"]=false;
            $datos["info"]="";
            $datos["mensaje"]="El medicamento que intentas registrar ya esta registrado";
        }
        $buscar->close();
        break;
}

echo json_encode($datos);
mysqli_close($conexion);
?>


